

<?php $__env->startSection('title', $board->name . ' | Forum'); ?>

<?php $__env->startSection('content'); ?>
<div class="forum-container">
    <div class="forum-breadcrumbs">
        <a href="<?php echo e(route('forum.index')); ?>">Forums</a>
        <span class="separator">/</span>
        <a href="<?php echo e(route('forum.index')); ?>"><?php echo e($board->category->name); ?></a>
        <span class="separator">/</span>
        <span class="current"><?php echo e($board->name); ?></span>
    </div>
    
    <div class="forum-board-header">
        <h1>
            <?php echo e($board->name); ?>

            
            <?php if(!$board->is_public): ?>
                <span class="forum-restricted-badge" title="Restricted Access">🔒</span>
            <?php endif; ?>
            <?php if(!$board->category->is_public): ?>
                <span class="forum-restricted-badge forum-restricted-badge--category" title="Category has restricted access">📁🔒</span>
            <?php endif; ?>
        </h1>
        <p><?php echo e($board->description); ?></p>
        
        
        <?php if(!$board->is_public || !$board->category->is_public): ?>
            <div class="forum-access-notice">
                <div class="forum-access-notice-content">
                    <h4>🔐 Access Information</h4>
                    <p>This is a restricted area. 
                    <?php if(auth()->guard()->check()): ?>
                        You have been granted access based on your roles and permissions.
                    <?php else: ?>
                        Please log in to participate.
                    <?php endif; ?>
                    </p>
                </div>
            </div>
        <?php endif; ?>
        
        <div class="actions">
            <?php if(auth()->guard()->check()): ?>
                
                <?php if($board->canAccess()): ?>
                    <a href="<?php echo e(route('forum.create-thread', $board->slug)); ?>" class="btn">Create New Thread</a>
                <?php else: ?>
                    <span class="btn btn-disabled" title="You don't have permission to create threads here">Create New Thread</span>
                <?php endif; ?>
            <?php else: ?>
                <a href="<?php echo e(route('login.steam')); ?>" class="btn">Login to Post</a>
            <?php endif; ?>
        </div>
    </div>
    
    <div class="forum-board-threads">
        <div class="thread-header">
            <div class="title">Title</div>
            <div class="replies">Replies</div>
            <div class="views">Views</div>
            <div class="activity">Latest Activity</div>
        </div>
        
        <?php $__empty_1 = true; $__currentLoopData = $threads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $thread): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="thread-item <?php echo e($thread->is_pinned ? 'pinned' : ''); ?> <?php echo e($thread->is_locked ? 'locked' : ''); ?>">
                <div class="thread-info">
                    <h3>
                        <?php if($thread->is_pinned): ?>
                            <svg class="pin-icon" xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" title="Pinned Thread">
                                <path d="M12 2L12 13"></path>
                                <circle cx="12" cy="17" r="3"></circle>
                            </svg>
                        <?php endif; ?>
                        
                        <?php if($thread->is_locked): ?>
                            <svg class="lock-icon" xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" title="Locked Thread">
                                <rect x="3" y="11" width="18" height="11" rx="2" ry="2"></rect>
                                <path d="M7 11V7a5 5 0 0 1 10 0v4"></path>
                            </svg>
                        <?php endif; ?>
                        
                        <a href="<?php echo e(route('forum.thread', [$board->slug, $thread->slug])); ?>"><?php echo e($thread->title); ?></a>
                    </h3>
                    <div class="meta">
                        Started by <a href="<?php echo e(route('users.show', $thread->user->slug)); ?>"><?php echo e($thread->user->name); ?></a> • <?php echo e($thread->created_at->diffForHumans()); ?>

                    </div>
                </div>
                
                <div class="thread-replies">
                    <?php echo e($thread->posts_count); ?>

                </div>
                
                <div class="thread-views">
                    <?php echo e($thread->view_count); ?>

                </div>
                
                <div class="thread-activity">
                    <?php if($lastPost = $thread->lastPost()): ?>
                        <div class="time"><?php echo e($lastPost->created_at->diffForHumans()); ?></div>
                        <div class="user">by <a href="<?php echo e(route('users.show', $lastPost->user->slug)); ?>"><?php echo e($lastPost->user->name); ?></a></div>
                    <?php else: ?>
                        <div class="time"><?php echo e($thread->created_at->diffForHumans()); ?></div>
                        <div class="user">by <a href="<?php echo e(route('users.show', $thread->user->slug)); ?>"><?php echo e($thread->user->name); ?></a></div>
                    <?php endif; ?>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="thread-item">
                <div class="thread-info">
                    <h3>No threads yet</h3>
                    <div class="meta">
                        <?php if(auth()->guard()->check()): ?>
                            Be the first to start a discussion!
                        <?php else: ?>
                            <a href="<?php echo e(route('login.steam')); ?>">Login</a> to start the conversation.
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
    
    <div class="mt-4">
        <?php echo e($threads->links()); ?>

    </div>

    
    <?php if(!$board->is_public || !$board->category->is_public): ?>
        <div class="forum-access-footer">
            <div class="forum-access-footer-content">
                <p><strong>Note:</strong> This board has restricted access. Content and participation may be limited based on your account permissions.</p>
            </div>
        </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/siedestudios.co.uk/edge/resources/views/forum/board.blade.php ENDPATH**/ ?>